unit Memou;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Memo2: TMemo;
    Label1: TLabel;
    Hossz: TEdit;
    KijeloltSzoveg: TButton;
    TeljesMasolas: TButton;
    Kilepes: TButton;
    Honnan: TEdit;
    Mennyit: TEdit;
    Leolvas: TButton;
    Torles: TButton;
    Edit2: TEdit;
    RadioGroup1: TRadioGroup;
    SzovegHossz: TButton;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure KilepesClick(Sender: TObject);
    procedure TeljesMasolasClick(Sender: TObject);
    procedure LeolvasClick(Sender: TObject);
    procedure TorlesClick(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure SzovegHosszClick(Sender: TObject);
    procedure KijeloltSzovegClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
   // a Memo1 kezdrtknek belltsa
   Memo1.Text := 'Ma szp az id. Remlem, holnap sem '+
    ' fog vltozni, mert kirndulni megynk.'+
    ' Ha mgis esne, akkor a programunk vltozik.';
end;

procedure TForm1.KilepesClick(Sender: TObject);
begin
   // a program futsnak befejezse
   Application.Terminate;
end;

procedure TForm1.TeljesMasolasClick(Sender: TObject);
begin
  Edit2.Clear;
  // a "Szveg hossza" szvegmez trlse
  Hossz.Clear;
  // a Memo1-ben lv teljes szveg Memo2-be msolsa
  Memo2.Text := Memo1.Text;
end;

procedure TForm1.LeolvasClick(Sender: TObject);
begin
   Memo2.Clear;
   Edit2.Clear;
   Hossz.Clear;
   // Memo2
   Memo2.Alignment := taLeftJustify;
   // a kijells kezdpozcija
   Honnan.Text := IntToStr(Memo1.SelStart);
   // a kijellt szveg hossza
   Mennyit.Text := IntToStr(Memo1.SelLength);
   if StrToInt(Mennyit.Text) > 0 then
   begin
      // ha van kijellt szveg, akkor
      // a Vgasztalra rsa
      Memo1.CopyToClipboard;
      // msols a Vgasztalrl a Memo2-be
      Memo2.PasteFromClipboard;
   end;
end;

procedure TForm1.TorlesClick(Sender: TObject);
begin
   // a "Szveg hossza" szvegmez trlse
   Hossz.Clear;
   // a Memo2 trlse
   Memo2.Clear;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  // a Memo2 szveg pozcionlsa
  case RadioGroup1.ItemIndex of
       // kzpre
    0: Memo1.Alignment:= taCenter;
       // balra
    1: Memo1.Alignment:= taLeftJustify;
       // jobbra
    2: Memo1.Alignment:= taRightJustify;
  end;
end;

procedure TForm1.SzovegHosszClick(Sender: TObject);
begin
   // a "Szveg hossza"
   Hossz.Text := IntToStr(Memo2.SelLength);
end;

procedure TForm1.KijeloltSzovegClick(Sender: TObject);
begin
  Edit2.Text:= Memo2.SelText;
end;

end.
